//Profitability Index
//OS:Windows 10
//Scilab 5.5.2

clear;
clc;
close;

//Given
projectA_investment = 30000     //in rupees
projectB_investment = 50000     //in rupees
estimatedlife_A = 5       //in years
estimatedlife_B = 5       //in years
scrapvalue_A = 2000    //in rupees
scrapvalue_B = 4000    //in rupees
pv_10 = [0.909,0.826,0.751,0.683,0.621]       //discount rate of 10%
projectA_CF = [10000,15000,8000,6000,4000]
projectB_CF = [40000,30000,10000,5000,4000]
pvcf_A = []       //present value
pvcf_B = []       //present value

//Solution
//Profitability Index for Project A
for i=1:5
    pvcf_A($+1) = pv_10(i) * projectA_CF(i)
end
total_pvcf = sum(pvcf_A)
PI_A = total_pvcf / projectA_investment

//Profitability Index for Project B
for i=1:5
    pvcf_B($+1) = pv_10(i) * projectB_CF(i)
end
total_pvcf = sum(pvcf_B)
PI_B = total_pvcf / projectB_investment

//Result
mprintf("\n  Particulars\t    Project A\t  Project B")
mprintf("\n\n  Initial Investment   %d        %d",projectA_investment,projectB_investment)
mprintf("\n  (in rupees)")
mprintf("\n\n  Estimated life")
mprintf("         %d\t      %d",estimatedlife_A,estimatedlife_B)
mprintf("\n  (in years)")
mprintf("\n\n  Scrap value")
mprintf("          %d\t    %d",scrapvalue_A,scrapvalue_B)
mprintf("\n  (in rupees)\n")
mprintf("\n  Year\tProject A CF\tProject B CF")
for i=1:5
    mprintf("\n   %d\t   %d     \t   %d",i,projectA_CF(i),projectB_CF(i))
end
mprintf("\n\n  Project A")
mprintf("\n  Year\tCash inflows(CF)     PV@10percent\tPVCF")
for i=1:5
    mprintf("\n   %d\t   %d   \t        %.3f\t        %d",i,projectA_CF(i),pv_10(i),pvcf_A(i))
end
mprintf("\n\n  Project B")
mprintf("\n  Year\tCash inflows(CF)     PV@10percent\tPVCF")
for i=1:5
    mprintf("\n   %d\t   %d   \t        %.3f\t        %d",i,projectB_CF(i),pv_10(i),pvcf_B(i))
end
mprintf("\n\n  Profitability Index for Project A: %.2f",PI_A)
mprintf("\n  Profitability Index for Project B: %.2f",PI_B)
if PI_A > PI_B then
    mprintf("\n  Project A proposal is accepted because its profatibility index is more")
else
    mprintf("\n  Project B proposal is accepted because its profatibility index is more")
end

//Output
//
//  Particulars	    Project A	  Project B
//
//  Initial Investment   30000        50000
//  (in rupees)
//
//  Estimated life         5	      5
//  (in years)
//
//  Scrap value          2000	    4000
//  (in rupees)
//
//  Year	Project A CF	Project B CF
//   1	   10000     	   40000
//   2	   15000     	   30000
//   3	   8000     	   10000
//   4	   6000     	   5000
//   5	   4000     	   4000
//
//  Project A
//  Year	Cash inflows(CF)     PV@10percent	PVCF
//   1	   10000   	        0.909	        9090
//   2	   15000   	        0.826	        12390
//   3	   8000   	        0.751	        6008
//   4	   6000   	        0.683	        4098
//   5	   4000   	        0.621	        2484
//
//  Project B
//  Year	Cash inflows(CF)     PV@10percent	PVCF
//   1	   40000   	        0.909	        36360
//   2	   30000   	        0.826	        24780
//   3	   10000   	        0.751	        7510
//   4	   5000   	        0.683	        3415
//   5	   4000   	        0.621	        2484
//
//  Profitability Index for Project A: 1.14
//  Profitability Index for Project B: 1.49
//  Project B proposal is accepted because its profatibility index is more
